import { assertMainOrNodeBoot } from "../../api/common/Env"

assertMainOrNodeBoot()

export function getTutaLogoSvg(highlightColor: string, textColor: string): string {
	return `<svg version="1.1" id="tuta_x5F_rgb" xmlns="http://www.w3.org/2000/svg"  x="0px"
	 y="0px" viewBox="0 0 279.5 100" style="enable-background:new 0 0 279.5 100;" xml:space="preserve">
<g>
	<g>
		<path style="fill: ${textColor};" d="M238.6,58.1c0-8.8,6.7-19.3,18.1-19.3h8.4l-3,9.6C258.6,59.9,253,67,246.2,67C241.3,67,238.6,63.6,238.6,58.1
			 M195.9,53.3c-4.2,13.5,2.2,22.8,16.7,22.8c2.1,0,4.9-0.2,5.7-0.4c0.4-0.1,0.6-0.3,0.8-0.8l2.5-8.4c0.1-0.5,0-0.9-0.7-0.8
			c-2.2,0.2-4.2,0.4-6,0.4c-7.3,0-10.3-3.9-8.1-10.9l5.1-16.4h14.8c0.4,0,0.7-0.2,0.9-0.7l2.6-8.5c0.1-0.5-0.1-0.8-0.7-0.8H215
			l1.9-6.2c0.1-0.4,0-0.7-0.3-1l-7.7-7c-0.4-0.4-0.9-0.3-1.1,0.3L195.9,53.3z M144.9,53.6c-4.3,13.7,2.6,22.7,13.4,22.7
			c6.2,0,11.1-3,14.6-7.9l-0.1,6.3c0,0.6,0.3,0.8,0.8,0.8h6.9c0.5,0,0.7-0.2,0.9-0.7l13.9-45.1c0.2-0.6-0.1-0.9-0.6-0.9h-9.9
			c-0.5,0-0.8,0.2-0.9,0.7l-5.9,19c-3.7,11.8-9.5,18.5-15.6,18.5c-6.1,0-8.7-4.8-6.4-12.2l7.8-25.1c0.2-0.6-0.1-0.9-0.6-0.9h-9.9
			c-0.5,0-0.7,0.2-0.9,0.7L144.9,53.6z M111.2,53.3c-4.2,13.5,2.2,22.8,16.7,22.8c2.1,0,4.9-0.2,5.7-0.4c0.4-0.1,0.6-0.3,0.8-0.8
			l2.5-8.4c0.1-0.5,0-0.9-0.7-0.8c-2.2,0.2-4.2,0.4-6,0.4c-7.3,0-10.3-3.9-8.1-10.9l5.1-16.4H142c0.4,0,0.8-0.2,0.9-0.7l2.6-8.5
			c0.1-0.5-0.1-0.8-0.7-0.8h-14.6l1.9-6.2c0.1-0.4,0-0.7-0.3-1l-7.7-7c-0.4-0.4-0.9-0.3-1.1,0.3L111.2,53.3z M242.6,76.3
			c5.8,0,10.6-2.6,14.2-7.9v6.3c0,0.5,0.3,0.8,0.8,0.8h6.9c0.5,0,0.7-0.2,0.9-0.7l14-45.2c0.1-0.5-0.1-0.9-0.6-0.9H257
			c-21.3,0-29.6,18.5-29.6,30.5C227.4,69.7,233.9,76.3,242.6,76.3"/>
	</g>
	<path style="fill: ${highlightColor};" d="M7.9,1L25,18.3c0.4,0.4,0.8,0.5,1.4,0.5h72.1c0.5,0,0.8-0.6,0.3-1.1L81.9,0.6C81.5,0.2,81.1,0,80.3,0h-72
		C7.6,0,7.5,0.6,7.9,1"/>
	<path style="fill: ${highlightColor};" d="M5.4,99.2C5.3,99.6,5.5,100,6,100h71.1c0.7,0,1-0.3,1.2-0.9l21.5-69.4c0.2-0.7-0.1-0.9-0.7-0.9H27.8
		c-0.6,0-0.8,0.2-1,0.7L5.4,99.2z"/>
	<path style="fill: ${highlightColor};" d="M0,79.2c0,0.8,1,0.8,1.2,0l16.3-53.1c0.2-0.6,0.2-1-0.3-1.5L1,8.5C0.6,8.1,0,8.3,0,8.8V79.2z"/>
</g>
</svg>`
}

export function getMailLogoSvg(highlightColor: string, secondaryColor: string, textColor: string): string {
	return `<svg x="0px" y="0px" viewBox="0 0 1408 309" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M305.76 89.5037H264.83C264.319 89.5037 263.865 89.674 263.467 90.0714L161.736 188.623C160.771 189.531 159.125 189.248 158.614 187.999L129.037 90.5823C128.753 89.8443 128.072 89.3901 127.277 89.3901H85.3814C84.5299 89.3901 83.7918 89.9578 83.508 90.7526L17.5987 306.193C17.2013 307.442 18.1664 308.634 19.4721 308.634H62.4465C63.2981 308.634 64.0361 308.066 64.3199 307.271L106.045 171.025C106.613 169.322 108.941 169.151 109.679 170.854L138.177 236.082C138.461 236.764 139.142 237.275 139.937 237.275H163.156C163.666 237.275 164.121 237.104 164.518 236.707L233.266 169.265C234.685 167.845 237.013 169.322 236.445 171.195L195.117 306.249C194.776 307.498 195.684 308.69 196.99 308.69H240.021C240.873 308.69 241.611 308.123 241.895 307.328L307.804 91.9448C308.145 90.6958 307.236 89.5037 305.931 89.5037H305.76Z" fill="${highlightColor}"/>
<path d="M52.9091 75.4818L3.17909 25.9788C2.55462 25.4111 1.81662 25.4679 1.75985 25.4679C0.794772 25.4679 0 26.2627 0 27.2277V244.882C0 245.847 0.794772 246.642 1.75985 246.642C2.49786 246.642 3.17909 246.131 3.40617 245.449C3.46294 245.393 3.46294 245.279 3.51971 245.166C3.51971 245.109 3.63324 244.655 3.63324 244.598L53.8174 80.0233C54.4419 78.2635 54.4419 77.0145 52.9091 75.4818Z" fill="${secondaryColor}"/>
<path d="M24.5247 4.34958L76.8661 57.3155C78.115 58.5644 79.3072 58.8482 81.1806 58.8482H305.988C307.52 58.8482 308.372 56.8613 306.896 55.4421L254.952 2.87357C252.681 0.659564 252.511 1.00018 250.013 1.00018H25.7168C24.7517 1.00018 23.957 1.79495 23.957 2.76003C23.957 2.8168 23.9002 3.61157 24.5814 4.29281C24.5247 4.23604 24.5247 4.29281 24.5814 4.29281L24.5247 4.34958Z" fill="${secondaryColor}"/>
<path d="M753.387 179.767C753.387 152.688 773.767 120.386 808.51 120.386H834.057L824.917 149.906C814.244 185.274 797.213 207.13 776.492 207.13C761.562 207.13 753.33 196.684 753.33 179.767H753.387ZM623.385 165.007C610.612 206.562 630.084 235.174 674.251 235.174C680.666 235.174 689.181 234.55 691.622 233.925C692.814 233.641 693.439 233.017 694.063 231.484L701.67 205.654C701.954 204.121 701.67 202.872 699.513 203.213C692.814 203.837 686.74 204.462 681.233 204.462C659.036 204.462 649.897 192.483 656.595 170.911L672.093 120.443H717.168C718.36 120.443 719.326 119.819 719.893 118.286L727.784 92.1151C728.068 90.5823 727.5 89.674 725.627 89.674H681.46L687.251 70.5994C687.535 69.3505 687.251 68.4422 686.342 67.5339L662.897 46.0183C661.705 44.7693 660.172 45.11 659.547 46.9266L623.328 165.064L623.385 165.007ZM468.121 165.915C455.007 208.095 476.012 235.742 508.938 235.742C527.842 235.742 542.716 226.488 553.388 211.444L553.105 230.803C553.105 232.676 554.013 233.244 555.546 233.244H576.55C578.083 233.244 578.708 232.619 579.275 231.087L621.569 92.3421C622.193 90.4688 621.285 89.5604 619.752 89.5604H589.607C588.075 89.5604 587.166 90.1849 586.882 91.7177L568.943 150.19C557.703 186.523 540.048 207.13 521.427 207.13C502.807 207.13 494.916 192.37 501.955 169.605L525.685 92.3989C526.309 90.5255 525.401 89.6172 523.868 89.6172H493.724C492.191 89.6172 491.567 90.2417 490.999 91.7744L468.178 165.915H468.121ZM365.538 165.007C352.765 206.562 372.237 235.174 416.404 235.174C422.819 235.174 431.334 234.55 433.775 233.925C434.967 233.641 435.592 233.017 436.216 231.484L443.823 205.654C444.107 204.121 443.823 202.872 441.666 203.213C434.967 203.837 428.893 204.462 423.386 204.462C401.19 204.462 392.05 192.483 398.748 170.911L414.247 120.443H459.322C460.514 120.443 461.763 119.819 462.046 118.286L469.937 92.1151C470.221 90.5823 469.654 89.674 467.78 89.674H423.33L429.12 70.5994C429.404 69.3505 429.12 68.4422 428.212 67.5339L404.766 46.0183C403.574 44.7693 402.041 45.11 401.417 46.9266L365.482 165.064L365.538 165.007ZM765.593 235.799C783.248 235.799 797.838 227.794 808.851 211.501V230.86C808.851 232.392 809.759 233.301 811.292 233.301H832.297C833.829 233.301 834.454 232.676 835.022 231.143L877.656 92.0583C877.939 90.5255 877.372 89.2766 875.839 89.2766H809.475C744.645 89.2766 719.382 146.216 719.382 183.116C719.382 215.418 739.195 235.742 765.649 235.742L765.593 235.799Z" fill="${textColor}"/>
<path d="M953.935 233.068H928.471C927.471 233.068 926.647 232.245 926.647 231.245V91.159C926.647 90.1593 927.471 89.3359 928.471 89.3359H948.584C949.29 89.3359 949.936 89.7476 950.23 90.3357L954.582 99.2161C955.17 100.392 956.641 100.569 957.523 99.6277C960.757 96.2167 964.463 93.2762 968.638 90.6298C973.637 87.5128 979.753 85.9837 986.928 85.9837C989.751 85.9837 992.868 86.3366 996.397 87.0423C999.925 87.748 1003.51 88.9243 1007.22 90.6298C1010.92 92.3353 1014.45 94.6289 1017.86 97.5106C1020.57 99.8042 1022.98 102.686 1025.04 106.097C1025.74 107.273 1027.39 107.332 1028.15 106.097C1031.51 100.98 1036.09 96.5108 1042.03 92.6881C1048.91 88.1597 1056.32 85.9249 1064.09 85.9249C1069.26 85.9249 1074.79 86.6895 1080.61 88.3361C1086.38 89.924 1091.85 92.9234 1096.79 97.3341C1101.78 101.745 1105.9 107.861 1109.08 115.624C1112.25 123.387 1113.9 133.502 1113.9 145.911V231.128C1113.9 232.127 1113.08 232.951 1112.08 232.951H1088.43C1087.43 232.951 1086.61 232.127 1086.61 231.128V145.617C1086.61 133.208 1084.02 124.563 1078.97 119.682C1073.85 114.801 1067.15 112.331 1058.74 112.331C1052.33 112.331 1046.74 115.036 1041.92 120.447C1037.09 125.857 1034.68 134.385 1034.68 145.97V231.186C1034.68 232.186 1033.86 233.01 1032.86 233.01H1009.22C1008.22 233.01 1007.39 232.186 1007.39 231.186V145.676C1007.39 133.267 1004.81 124.622 999.749 119.741C994.632 114.86 987.928 112.39 979.518 112.39C973.519 112.39 968.285 114.683 963.757 119.329C959.228 123.916 956.582 131.15 955.817 140.913V231.245C955.817 232.245 954.994 233.068 953.994 233.068H953.935Z" fill="${highlightColor}"/>
<path d="M1284.39 91.1593V231.246C1284.39 232.245 1283.57 233.069 1282.57 233.069H1261.16C1260.34 233.069 1259.63 232.539 1259.4 231.716L1256.22 219.954C1255.81 218.542 1254.04 218.19 1253.04 219.307C1248.4 224.6 1242.75 228.658 1236.05 231.598C1228.23 235.009 1220.35 236.715 1212.35 236.715C1202.35 236.715 1193 234.774 1184.3 230.893C1175.59 227.011 1168.01 221.659 1161.48 214.837C1154.95 208.015 1149.83 200.017 1146.01 190.843C1142.19 181.61 1140.31 171.847 1140.31 161.438C1140.31 151.028 1142.19 141.266 1146.01 132.032C1149.83 122.799 1154.95 114.801 1161.48 108.038C1168.01 101.275 1175.59 95.8641 1184.3 91.9826C1193 88.1011 1202.35 86.1604 1212.35 86.1604C1220.35 86.1604 1228.05 87.6895 1235.46 90.8064C1241.93 93.5117 1247.81 97.5696 1253.1 102.98C1254.1 103.98 1255.75 103.627 1256.16 102.274L1259.4 90.7476C1259.63 89.9831 1260.34 89.395 1261.16 89.395H1282.57C1283.57 89.395 1284.39 90.2183 1284.39 91.2181V91.1593ZM1212.35 210.897C1218.11 210.897 1223.64 209.603 1228.87 207.016C1234.05 204.428 1238.58 200.841 1242.4 196.371C1246.16 191.901 1249.16 186.608 1251.4 180.61C1253.57 174.611 1254.69 168.201 1254.69 161.379C1254.69 154.557 1253.57 148.205 1251.4 142.148C1249.22 136.149 1246.22 130.915 1242.4 126.387C1238.58 121.917 1234.11 118.33 1228.87 115.742C1223.64 113.154 1218.17 111.861 1212.35 111.861C1206.53 111.861 1201.06 113.154 1195.82 115.742C1190.59 118.33 1186.12 121.917 1182.3 126.387C1178.47 130.915 1175.47 136.149 1173.3 142.148C1171.12 148.146 1170 154.557 1170 161.379C1170 168.201 1171.12 174.611 1173.3 180.61C1175.47 186.608 1178.47 191.843 1182.3 196.371C1186.06 200.899 1190.59 204.428 1195.82 207.016C1201.06 209.603 1206.53 210.897 1212.35 210.897Z" fill="${highlightColor}"/>
<path d="M1329.67 58.1078C1323.91 58.1078 1319.15 55.873 1315.33 51.3446C1312.91 48.4629 1311.38 44.7579 1311.15 40.994C1310.68 34.9954 1312.5 30.0553 1316.5 26.0562C1320.09 22.4688 1324.5 20.6456 1329.73 20.6456C1334.97 20.6456 1339.32 22.4688 1342.97 26.0562C1346.97 30.0553 1348.73 35.0542 1348.32 40.994C1348.02 44.7579 1346.55 48.4629 1344.14 51.3446C1340.32 55.873 1335.56 58.1078 1329.79 58.1078H1329.67ZM1342.85 233.069H1317.09C1316.09 233.069 1315.27 232.245 1315.27 231.245V91.1592C1315.27 90.1595 1316.09 89.3361 1317.09 89.3361H1342.55C1343.55 89.3361 1344.38 90.1595 1344.38 91.1592L1344.67 231.245C1344.67 232.245 1343.85 233.069 1342.85 233.069Z" fill="${highlightColor}"/>
<path d="M1407.72 15.8231V231.245C1407.72 232.245 1406.89 233.069 1405.89 233.069H1380.43C1379.43 233.069 1378.6 232.245 1378.6 231.245V15.8231C1378.6 14.8233 1379.43 14 1380.43 14H1405.89C1406.89 14 1407.72 14.8233 1407.72 15.8231Z" fill="${highlightColor}"/>
</svg>`
}

export function getCalendarLogoSvg(highlightColor: string, secondaryColor: string, textColor: string): string {
	return `<svg x="0px" y="0px" viewBox="0 0 1999 308" fill="none" xmlns="http://www.w3.org/2000/svg">
	<path d="M753.202 178.742C753.202 151.67 773.577 119.376 808.311 119.376H833.851L824.714 148.889C814.044 184.247 797.017 206.098 776.301 206.098C761.375 206.098 753.145 195.655 753.145 178.742H753.202ZM623.232 163.986C610.462 205.53 629.929 234.135 674.085 234.135C680.498 234.135 689.011 233.511 691.452 232.887C692.644 232.603 693.268 231.979 693.892 230.446L701.498 204.622C701.781 203.09 701.498 201.841 699.341 202.182C692.644 202.806 686.571 203.431 681.066 203.431C658.874 203.431 649.737 191.455 656.434 169.888L671.928 119.433H716.992C718.184 119.433 719.149 118.808 719.716 117.276L727.605 91.1115C727.889 89.5792 727.321 88.6711 725.448 88.6711H681.293L687.082 69.6013C687.366 68.3526 687.082 67.4445 686.174 66.5365L662.734 45.0261C661.542 43.7775 660.009 44.1181 659.385 45.9342L623.175 164.042L623.232 163.986ZM468.006 164.894C454.895 207.063 475.895 234.703 508.813 234.703C527.713 234.703 542.582 225.452 553.253 210.411L552.969 229.765C552.969 231.638 553.877 232.206 555.409 232.206H576.409C577.941 232.206 578.565 231.581 579.133 230.049L621.416 91.3386C622.04 89.4656 621.132 88.5576 619.6 88.5576H589.462C587.93 88.5576 587.022 89.1819 586.738 90.7143L568.803 149.172C557.566 185.496 539.915 206.098 521.299 206.098C502.683 206.098 494.794 191.342 501.832 168.583L525.556 91.3953C526.18 89.5224 525.272 88.6143 523.74 88.6143H493.603C492.07 88.6143 491.446 89.2386 490.878 90.771L468.063 164.894H468.006ZM365.449 163.986C352.679 205.53 372.146 234.135 416.302 234.135C422.715 234.135 431.228 233.511 433.669 232.887C434.861 232.603 435.485 231.979 436.109 230.446L443.715 204.622C443.998 203.09 443.715 201.841 441.558 202.182C434.861 202.806 428.788 203.431 423.283 203.431C401.091 203.431 391.954 191.455 398.651 169.888L414.145 119.433H459.209C460.401 119.433 461.649 118.808 461.933 117.276L469.822 91.1115C470.106 89.5792 469.538 88.6711 467.665 88.6711H423.226L429.015 69.6013C429.299 68.3526 429.015 67.4445 428.107 66.5365L404.667 45.0261C403.475 43.7775 401.943 44.1181 401.318 45.9342L365.392 164.042L365.449 163.986ZM765.404 234.76C783.055 234.76 797.641 226.757 808.652 210.468V229.822C808.652 231.354 809.56 232.262 811.092 232.262H832.092C833.624 232.262 834.249 231.638 834.816 230.106L877.439 91.0548C877.723 89.5224 877.156 88.2738 875.623 88.2738H809.276C744.461 88.2738 719.205 145.199 719.205 182.091C719.205 214.384 739.013 234.703 765.461 234.703L765.404 234.76Z" fill="${textColor}"/>
	<path d="M195.012 84.8116H84.5094C83.7716 84.8116 83.1472 85.2657 82.9202 85.9468C82.8635 86.2873 71.1719 124.767 71.1719 124.767C70.8313 126.016 71.7962 127.435 73.1583 127.492H121.23C122.99 127.492 124.181 129.762 122.876 130.897L76.1663 173.52C75.5988 174.031 75.4853 174.882 75.8826 175.62L88.1985 201.614C88.7093 202.749 89.9579 203.203 90.9795 202.749C95.6334 200.479 100.571 199.344 105.679 199.344C110.39 199.344 114.419 200.195 117.655 202.012C120.89 203.714 123.444 206.155 125.26 209.106C127.133 212.114 128.154 215.576 128.381 219.606C128.608 223.692 128.098 227.892 126.679 232.376C125.317 236.689 123.217 240.889 120.379 244.862C117.541 248.835 114.476 252.524 110.617 255.362C68.0503 285.669 43.5887 254.737 35.3024 248.892C34.1673 248.097 32.8619 248.438 32.4647 249.573L23.5541 277.269C23.4405 277.723 23.4405 278.177 23.6676 278.688C26.2783 284.25 29.7404 289.074 34.1106 293.218C38.9915 297.758 44.6671 301.277 51.2507 303.831C57.8343 306.442 65.2693 307.69 73.4421 307.69C83.9418 307.69 94.3848 305.647 104.828 301.674C115.214 297.701 124.919 292.139 134 285.215C142.967 278.177 150.97 270.118 157.894 260.98C164.762 251.843 169.87 242.024 173.218 231.524C177.304 218.811 178.269 206.949 176.169 195.939C174.069 184.928 169.132 175.847 161.356 168.639C156.362 164.212 150.175 161.034 142.74 158.991C141.208 158.537 140.527 156.721 141.492 155.756L190.926 106.606C190.926 106.606 191.21 106.152 191.266 105.925L197.055 87.7062C197.509 86.344 196.318 84.9252 194.955 84.9252L195.012 84.8116Z" fill="${highlightColor}"/>
	<path d="M305.061 84.8116H236.841C235.99 84.8116 235.308 85.3224 235.081 86.0603L223.333 124.427C222.879 125.846 224.184 127.435 225.717 127.435H244.957C246.546 127.435 247.795 129.024 247.341 130.443L194.899 300.766C194.445 302.185 195.75 303.774 197.282 303.774H239.565C240.416 303.774 241.098 303.263 241.325 302.525L307.445 87.8197C307.899 86.4008 306.593 84.8116 305.004 84.8116H305.061Z" fill="${highlightColor}"/>
	<path d="M52.8961 74.4249L3.1783 24.9909C2.55399 24.4233 1.81617 24.4801 1.75942 24.4801C0.794576 24.4801 0 25.2747 0 26.2395V243.67C0 244.634 0.794576 245.429 1.75942 245.429C2.49724 245.429 3.1783 244.918 3.40533 244.237C3.46208 244.18 3.46208 244.067 3.51884 243.953C3.51884 243.897 3.63235 243.443 3.63235 243.386L53.8041 78.9653C54.4284 77.2059 54.4284 75.9573 52.8961 74.4249Z" fill="${secondaryColor}"/>
	<path d="M24.5747 3.36742L76.9032 56.3202C78.1518 57.5689 79.3437 57.8526 81.2166 57.8526H305.968C307.5 57.8526 308.352 55.8662 306.876 54.4473L254.888 1.89178C252.618 -0.321679 252.448 0.018853 249.95 0.018853H25.7098C24.745 0.018853 23.9504 0.813429 23.9504 1.77827C23.9504 1.83503 23.8936 2.6296 24.5747 3.31067C24.5179 3.25391 24.5179 3.31067 24.5747 3.31067V3.36742Z" fill="${secondaryColor}"/>
	<path d="M1009.68 203.642C1003.27 207.82 996.149 209.938 988.383 209.938C982.381 209.938 976.673 208.644 971.26 206.055C965.847 203.466 961.14 199.877 957.138 195.405C953.137 190.933 949.96 185.637 947.665 179.635C945.37 173.634 944.193 167.22 944.193 160.454C944.193 153.687 945.37 147.215 947.665 141.213C949.96 135.211 953.137 130.033 957.138 125.62C961.14 121.207 965.847 117.736 971.26 115.264C976.673 112.734 982.381 111.499 988.383 111.499C995.384 111.499 1001.92 113.146 1008.04 116.441C1014.1 119.736 1019.16 124.267 1023.16 130.092L1043.57 114.205C1036.93 105.203 1028.75 98.083 1018.92 92.8462C1009.09 87.6095 998.385 85.0793 986.794 85.0793C976.791 85.0793 967.435 87.0211 958.727 90.9045C950.019 94.788 942.428 100.142 936.015 106.968C929.542 113.734 924.482 121.796 920.716 130.975C916.951 140.213 915.068 149.98 915.068 160.395C915.068 170.809 916.951 180.577 920.716 189.815C924.482 199.053 929.601 207.055 936.015 213.822C942.487 220.647 950.019 226.002 958.727 229.885C967.435 233.768 976.791 235.71 986.794 235.71C998.797 235.71 1009.92 232.827 1020.1 227.178C1030.28 221.53 1038.63 213.822 1045.05 204.231L1025.22 186.814C1021.22 193.816 1015.98 199.406 1009.62 203.642H1009.68Z" fill="${highlightColor}"/>
	<path d="M1173.55 88.3743L1169.08 104.261C1163.26 97.671 1156.67 92.7873 1149.25 89.6688C1141.84 86.5502 1134.13 85.0204 1126.13 85.0204C1116.13 85.0204 1106.77 86.9621 1098.06 90.8456C1089.35 94.729 1081.76 100.083 1075.23 106.909C1068.76 113.676 1063.58 121.737 1059.76 130.916C1055.93 140.154 1054.05 149.921 1054.05 160.336C1054.05 170.751 1055.93 180.518 1059.76 189.756C1063.58 198.994 1068.7 206.996 1075.23 213.763C1081.7 220.588 1089.35 225.943 1098.06 229.826C1106.77 233.709 1116.13 235.651 1126.13 235.651C1134.13 235.651 1142.01 233.945 1149.84 230.532C1157.61 227.119 1164.02 222.118 1169.02 215.528L1173.49 232.062H1198.15V88.2566H1173.49L1173.55 88.3743ZM1165.14 179.635C1162.96 185.637 1159.96 190.874 1156.14 195.405C1152.31 199.935 1147.84 203.466 1142.6 206.055C1137.37 208.644 1131.89 209.938 1126.07 209.938C1120.24 209.938 1114.77 208.644 1109.53 206.055C1104.36 203.466 1099.83 199.876 1096 195.405C1092.18 190.933 1089.18 185.637 1087 179.635C1084.82 173.634 1083.7 167.22 1083.7 160.453C1083.7 153.687 1084.82 147.214 1087 141.213C1089.18 135.211 1092.18 129.974 1096 125.444C1099.77 120.972 1104.3 117.382 1109.53 114.794C1114.71 112.205 1120.24 110.91 1126.07 110.91C1131.89 110.91 1137.37 112.205 1142.6 114.794C1147.78 117.382 1152.31 120.972 1156.14 125.444C1159.9 129.974 1162.9 135.211 1165.14 141.213C1167.32 147.214 1168.43 153.628 1168.43 160.453C1168.43 167.279 1167.32 173.693 1165.14 179.635Z" fill="${highlightColor}"/>
	<path d="M1252.63 13.0001H1223.51V232.18H1252.63V13.0001Z" fill="${highlightColor}"/>
	<path d="M1405.62 133.564C1402.21 122.443 1397.44 113.323 1391.32 106.085C1385.2 98.8479 1378.02 93.5523 1369.67 90.1984C1361.37 86.7857 1352.31 85.0793 1342.48 85.0793C1332.66 85.0793 1323.89 87.0211 1315.48 90.9045C1307.06 94.788 1299.71 100.142 1293.41 106.968C1287.11 113.734 1282.11 121.796 1278.41 130.975C1274.7 140.213 1272.87 149.98 1272.87 160.395C1272.87 170.809 1274.82 180.577 1278.7 189.815C1282.58 199.053 1287.94 207.055 1294.76 213.822C1301.53 220.647 1309.53 226.002 1318.59 229.885C1327.71 233.768 1337.48 235.71 1347.9 235.71C1359.9 235.71 1370.96 233.592 1381.08 229.414C1391.2 225.237 1399.73 219.588 1406.74 212.586L1388.73 194.581C1384.14 199.17 1378.55 202.877 1372.08 205.702C1365.55 208.526 1358.55 209.879 1350.9 209.879C1345.31 209.879 1339.95 208.997 1334.83 207.173C1329.71 205.349 1325.12 202.818 1321.01 199.523C1316.89 196.228 1313.36 192.286 1310.36 187.814C1307.36 183.342 1305.12 178.459 1303.71 173.222H1410.62C1410.62 157.806 1408.91 144.567 1405.5 133.446L1405.62 133.564ZM1303.53 147.568C1304.71 142.39 1306.59 137.565 1309.06 133.152C1311.59 128.739 1314.53 124.914 1318.06 121.737C1321.54 118.559 1325.36 116.029 1329.48 114.264C1333.6 112.44 1337.95 111.557 1342.54 111.557C1348.19 111.557 1353.07 112.499 1357.43 114.441C1361.72 116.323 1365.49 118.912 1368.67 122.207C1371.84 125.503 1374.37 129.386 1376.2 133.74C1377.96 138.153 1379.08 142.743 1379.49 147.568H1303.53Z" fill="${highlightColor}"/>
	<path d="M1537.42 96.4943C1531.71 92.0813 1525.59 89.0805 1518.94 87.4918C1512.35 85.9031 1506.41 85.0793 1501.23 85.0793C1493.23 85.0793 1485.82 86.5504 1478.99 89.5512C1472.22 92.552 1466.4 96.3767 1461.57 100.966L1455.57 88.3744H1432.45V232.18H1461.57V144.508C1461.57 138.506 1462.87 133.446 1465.34 129.327C1467.81 125.208 1470.87 121.854 1474.52 119.089C1478.11 116.382 1481.99 114.441 1486.05 113.264C1490.11 112.087 1493.82 111.44 1497 111.44C1501.23 111.44 1505.23 112.028 1509.18 113.087C1513.12 114.146 1516.59 116.029 1519.71 118.618C1522.83 121.207 1525.3 124.679 1527.18 128.974C1529.06 133.269 1530.06 138.506 1530.06 144.743V232.121H1557.72V145.037C1557.72 132.622 1555.78 122.561 1551.84 114.735C1547.95 106.968 1543.13 100.849 1537.42 96.4355V96.4943Z" fill="${highlightColor}"/>
	<path d="M1690.05 103.967C1684.64 97.9653 1678.22 93.3169 1670.87 89.9631C1663.46 86.668 1654.75 85.0205 1644.74 85.0205C1634.74 85.0205 1625.5 86.9622 1617.09 90.8456C1608.68 94.7291 1601.38 100.084 1595.14 106.909C1588.96 113.676 1584.08 121.737 1580.55 130.916C1577.02 140.095 1575.31 149.921 1575.31 160.336C1575.31 170.751 1577.08 180.518 1580.55 189.756C1584.02 198.994 1588.9 206.996 1595.14 213.763C1601.32 220.588 1608.68 225.943 1617.09 229.826C1625.5 233.71 1634.68 235.651 1644.74 235.651C1654.81 235.651 1662.87 234.004 1670.28 230.709C1677.69 227.414 1684.28 222.883 1690.11 217.058L1696.11 232.062H1719.24V13.0001H1690.11V103.967H1690.05ZM1686.4 182.342C1684.23 188.52 1681.11 193.698 1677.22 197.817C1673.34 201.936 1668.81 204.996 1663.69 206.996C1658.57 208.997 1652.98 209.997 1646.98 209.997C1640.98 209.997 1635.62 208.702 1630.39 206.114C1625.21 203.525 1620.68 199.935 1616.85 195.463C1613.03 190.992 1610.03 185.696 1607.79 179.694C1605.56 173.693 1604.5 167.279 1604.5 160.512C1604.5 153.746 1605.62 147.273 1607.79 141.272C1609.97 135.27 1612.97 130.092 1616.85 125.679C1620.68 121.266 1625.21 117.794 1630.39 115.323C1635.62 112.793 1641.15 111.557 1646.98 111.557C1652.81 111.557 1658.57 112.44 1663.69 114.088C1668.81 115.794 1673.34 118.618 1677.22 122.502C1681.11 126.385 1684.23 131.445 1686.4 137.682C1688.58 143.861 1689.7 151.51 1689.7 160.512C1689.7 168.927 1688.58 176.223 1686.4 182.46V182.342Z" fill="${highlightColor}"/>
	<path d="M1850.92 104.261C1845.1 97.671 1838.5 92.7873 1831.09 89.6688C1823.68 86.5502 1815.97 85.0204 1807.97 85.0204C1797.96 85.0204 1788.61 86.9621 1779.9 90.8456C1771.19 94.729 1763.6 100.083 1757.07 106.909C1750.6 113.676 1745.42 121.737 1741.6 130.916C1737.77 140.154 1735.89 149.921 1735.89 160.336C1735.89 170.751 1737.77 180.518 1741.6 189.756C1745.42 198.994 1750.54 206.996 1757.07 213.763C1763.54 220.588 1771.19 225.943 1779.9 229.826C1788.61 233.709 1797.96 235.651 1807.97 235.651C1815.97 235.651 1823.85 233.945 1831.68 230.532C1839.45 227.119 1845.86 222.118 1850.86 215.528L1855.33 232.062H1879.99V88.2566H1855.33L1850.86 104.143L1850.92 104.261ZM1847.04 179.635C1844.86 185.637 1841.86 190.874 1838.03 195.405C1834.21 199.935 1829.74 203.466 1824.5 206.055C1819.26 208.644 1813.79 209.938 1807.97 209.938C1802.14 209.938 1796.67 208.644 1791.43 206.055C1786.25 203.466 1781.72 199.876 1777.9 195.405C1774.07 190.933 1771.07 185.637 1768.9 179.635C1766.72 173.634 1765.6 167.22 1765.6 160.453C1765.6 153.687 1766.72 147.214 1768.9 141.213C1771.07 135.211 1774.07 129.974 1777.9 125.444C1781.67 120.972 1786.2 117.382 1791.43 114.794C1796.61 112.205 1802.14 110.91 1807.97 110.91C1813.79 110.91 1819.26 112.205 1824.5 114.794C1829.68 117.382 1834.21 120.972 1838.03 125.444C1841.8 129.974 1844.8 135.211 1847.04 141.213C1849.21 147.214 1850.33 153.628 1850.33 160.453C1850.33 167.279 1849.21 173.693 1847.04 179.635Z" fill="${highlightColor}"/>
	<path d="M1976.25 85.0792C1966.42 85.0792 1958.25 86.7856 1951.77 90.316C1945.3 93.7876 1940 98.4948 1936 104.261L1930 88.3743H1906.88V232.18H1936L1936.3 146.92C1936.3 142.095 1937.36 137.565 1939.48 133.269C1941.59 128.974 1944.42 125.208 1948.01 122.031C1951.6 118.853 1955.95 116.265 1960.95 114.382C1965.95 112.499 1971.37 111.498 1977.13 111.498C1978.96 111.498 1980.66 111.675 1982.25 112.087C1983.84 112.499 1985.25 112.852 1986.43 113.264C1987.84 113.852 1989.25 114.44 1990.61 115.029L1998.14 87.727C1989.9 85.903 1982.6 85.0204 1976.19 85.0204L1976.25 85.0792Z" fill="${highlightColor}"/>
</svg>`
}
