import { matchers, object, when } from "testdouble"
import { IServiceExecutor } from "../../../src/common/api/common/ServiceRequest.js"
import { UpgradePriceService } from "../../../src/common/api/entities/sys/Services.js"
import { PlanConfigurationTypeRef, PlanPricesTypeRef } from "../../../src/common/api/entities/sys/TypeRefs.js"
import { createTestEntity } from "../TestUtils.js"

export const PLAN_PRICES = {
	Free: createTestEntity(PlanPricesTypeRef, {
		additionalUserPriceMonthly: "0.00",
		business: false,
		firstYearDiscount: "0",
		includedAliases: "0",
		includedStorage: "1",
		monthlyPrice: "0.00",
		monthlyReferencePrice: "0.00",
		sharing: false,
		whitelabel: false,
		planName: "Free",
		businessPlan: false,
		planConfiguration: createTestEntity(PlanConfigurationTypeRef, {
			nbrOfAliases: "0",
			whitelabel: false,
		}),
	}),
	PremiumBusiness: createTestEntity(PlanPricesTypeRef, {
		_id: "",
		_type: undefined,
		customDomains: "",
		sharing: false,
		whitelabel: false,
		additionalUserPriceMonthly: "2.40",
		business: true,
		firstYearDiscount: "0",
		includedAliases: "5",
		includedStorage: "1",
		monthlyPrice: "2.40",
		monthlyReferencePrice: "2.40",
		planName: "PremiumBusiness",
		businessPlan: true,
		planConfiguration: createTestEntity(PlanConfigurationTypeRef, {
			nbrOfAliases: "5",
			whitelabel: false,
		}),
	}),
	Premium: createTestEntity(PlanPricesTypeRef, {
		additionalUserPriceMonthly: "1.20",
		business: false,
		firstYearDiscount: "0",
		includedAliases: "5",
		includedStorage: "1",
		monthlyPrice: "1.20",
		monthlyReferencePrice: "1.20",
		planName: "Premium",
		businessPlan: false,
		planConfiguration: createTestEntity(PlanConfigurationTypeRef, {
			nbrOfAliases: "5",
			whitelabel: false,
		}),
	}),
	Pro: createTestEntity(PlanPricesTypeRef, {
		additionalUserPriceMonthly: "4.80",
		business: true,
		firstYearDiscount: "0",
		includedAliases: "20",
		includedStorage: "10",
		monthlyPrice: "8.40",
		monthlyReferencePrice: "8.40",
		planName: "Pro",
		businessPlan: true,
		planConfiguration: createTestEntity(PlanConfigurationTypeRef, {
			nbrOfAliases: "20",
			whitelabel: false,
		}),
	}),
	TeamsBusiness: createTestEntity(PlanPricesTypeRef, {
		additionalUserPriceMonthly: "3.60",
		business: true,
		firstYearDiscount: "0",
		includedAliases: "5",
		includedStorage: "10",
		monthlyPrice: "6.00",
		monthlyReferencePrice: "6.00",
		planName: "TeamsBusiness",
		businessPlan: true,
		planConfiguration: createTestEntity(PlanConfigurationTypeRef, {
			nbrOfAliases: "5",
			whitelabel: false,
		}),
	}),
	Teams: createTestEntity(PlanPricesTypeRef, {
		additionalUserPriceMonthly: "2.40",
		business: false,
		firstYearDiscount: "0",
		includedAliases: "5",
		includedStorage: "10",
		monthlyPrice: "4.80",
		monthlyReferencePrice: "4.80",
		planName: "Teams",
		businessPlan: false,
		planConfiguration: createTestEntity(PlanConfigurationTypeRef, {
			nbrOfAliases: "5",
			whitelabel: false,
		}),
	}),
	Revolutionary: createTestEntity(PlanPricesTypeRef, {
		additionalUserPriceMonthly: "3.60",
		business: true,
		firstYearDiscount: "0",
		includedAliases: "15",
		includedStorage: "20",
		monthlyPrice: "3.60",
		monthlyReferencePrice: "3.60",
		sharing: true,
		whitelabel: false,
		planName: "Revolutionary",
		businessPlan: false,
		planConfiguration: createTestEntity(PlanConfigurationTypeRef, {
			nbrOfAliases: "15",
			whitelabel: false,
		}),
	}),
	Legend: createTestEntity(PlanPricesTypeRef, {
		additionalUserPriceMonthly: "9.60",
		business: true,
		firstYearDiscount: "0",
		includedAliases: "30",
		includedStorage: "500",
		monthlyPrice: "9.60",
		monthlyReferencePrice: "9.60",
		sharing: true,
		whitelabel: false,
		planName: "Legend",
		businessPlan: false,
		planConfiguration: createTestEntity(PlanConfigurationTypeRef, {
			nbrOfAliases: "30",
			whitelabel: false,
		}),
	}),
	Essential: createTestEntity(PlanPricesTypeRef, {
		additionalUserPriceMonthly: "7.20",
		business: true,
		firstYearDiscount: "0",
		includedAliases: "15",
		includedStorage: "50",
		monthlyPrice: "7.20",
		monthlyReferencePrice: "7.20",
		sharing: true,
		whitelabel: false,
		planName: "Essential",
		businessPlan: true,
		planConfiguration: createTestEntity(PlanConfigurationTypeRef, {
			nbrOfAliases: "15",
			whitelabel: false,
		}),
	}),
	Advanced: createTestEntity(PlanPricesTypeRef, {
		additionalUserPriceMonthly: "9.60",
		business: true,
		firstYearDiscount: "0",
		includedAliases: "30",
		includedStorage: "500",
		monthlyPrice: "9.60",
		monthlyReferencePrice: "9.60",
		sharing: true,
		whitelabel: false,
		planName: "Advanced",
		businessPlan: true,
		planConfiguration: createTestEntity(PlanConfigurationTypeRef, {
			nbrOfAliases: "30",
			whitelabel: false,
		}),
	}),
	Unlimited: createTestEntity(PlanPricesTypeRef, {
		additionalUserPriceMonthly: "14.40",
		business: true,
		firstYearDiscount: "0",
		includedAliases: "30",
		includedStorage: "1000",
		monthlyPrice: "14.40",
		monthlyReferencePrice: "14.40",
		sharing: true,
		whitelabel: true,
		planName: "Unlimited",
		businessPlan: true,
		planConfiguration: createTestEntity(PlanConfigurationTypeRef, {
			nbrOfAliases: "30",
			whitelabel: true,
		}),
	}),
}

/**
 * gives a real PriceAndConfigProvider with mocked data
 */
export function createUpgradePriceServiceMock(
	planPrices: typeof PLAN_PRICES = PLAN_PRICES,
	registrationDataId: string | null = null,
	bonusMonths: number = 0,
): IServiceExecutor {
	const executorMock = object<IServiceExecutor>()
	when(executorMock.get(UpgradePriceService, matchers.anything())).thenResolve({
		premiumPrices: planPrices.Premium,
		premiumBusinessPrices: planPrices.PremiumBusiness,
		teamsPrices: planPrices.Teams,
		teamsBusinessPrices: planPrices.TeamsBusiness,
		proPrices: planPrices.Pro,
		revolutionaryPrices: planPrices.Revolutionary,
		legendaryPrices: planPrices.Legend,
		essentialPrices: planPrices.Essential,
		advancedPrices: planPrices.Advanced,
		unlimitedPrices: planPrices.Unlimited,
		freePrices: planPrices.Free,
		bonusMonthsForYearlyPlan: String(bonusMonths),
		plans: Object.values(planPrices),
	})
	return executorMock
}
