## General communication guidelines

Ulauncher is a free, open source software project developed by a small team of volunteers and contributors.

We are here because we want Ulauncher to improve, and for that we have to:
* Act respectful towards each other.
* Give each other the benefit of the doubt.
* Give and accept constructive feedback.
* Avoid arguments.
* Learn from past mistakes.
* Focus on what is best, not just for us as individuals, but for the Ulauncher community.
* Refrain from elevating the importance of ones own specific needs above all other concerns.
* Leave aside anything that is unhelpful for the Ulauncher progress, such as politics or non-constructive rhetorics.

We will not tolerate harassment, personal attacks, derogatory comments, trolling, or uncivil behavior. Failure to comply will result in comments being hidden, moderated or removed. On very serious or repeat offenses users violating our terms will be blocked from the repository.

### Asking for help or requesting changes

The maintainers and contributors want their time spent contributing to Ulauncher to be as productive and constructive as possible. Please respect this time when you are requesting help, improvements, or new features. Do your due diligence before you report issues or contact us asking for help. Read the actual error messages you are getting (if any), and don't ask us about things that are documented or previously covered. We have to prioritize tasks based on how helpful the reports were, and close issues that don't provide enough information.

1. Our [Dicussions](https://github.com/Ulauncher/Ulauncher/discussions) and [Issue tracker](https://github.com/Ulauncher/Ulauncher/issues) have many answers, in particular the [Troubleshooting](https://github.com/Ulauncher/Ulauncher/discussions/991) discussion page. Please use these before you ask for help. You can use the GitHub search box (located to the upper left on a desktop computer) to search all of these. Often you can find help or similar issues there rather than starting a new issue. If you can't find any information or references to your issue in our repository, then it's likely that the error is not directly with the Ulauncher code, but an issue with your system, or Ulauncher's dependencies on your system, but it may be good to create an issue or discussion anyway in case others have the same issue.
2. Our [Developer resources](https://github.com/Ulauncher/Ulauncher/discussions/879) have more help to offer for extension developers, color theme developers and contributors.
3. If you find an issue and want to show that you agree with a previous comment, use the :+1: reaction. Do not write a comment if you want to repeat something that has already been said or want to know when something will be implemented.
4. Please understand that there are lots of standards, environments, priorities, use-cases, dependencies and architectural debts/costs that makes software development hard and time-consuming. Ulauncher makes no money and all of our volunteers are limited to their spare time. You cannot expect or demand our time to address your specific concerns. Only those actually volunteering their time to help out have an influence on priority, what gets implemented, how it gets implemented and the direction of the project.
5. As a clarification to previous point, we do listen to respectful constructive criticism and matter-of-factly suggestions to change our direction. Just because we went with a decision in the past doesn't mean it's final. Software development is based on making compromises, so chances are we would be open to your suggestions or even considered them ourselves.
