# -*- coding: UTF-8 -*-
"""
Name: about_app.py
Porpose: Gets information about the program
Compatibility: Python3, Python2
author: Gianluca Pernigotto <jeanlucperni@gmail.com>
Copyleft - 2024 Gianluca Pernigotto <jeanlucperni@gmail.com>
lic: GPL3
Rev: June.26.2024
Code checker: flake8, pylint

This file is part of Videomass.

   Videomass is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Videomass is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Videomass.  If not, see <http://www.gnu.org/licenses/>.
"""
PRGNAME = 'videomass'
RELNAME = 'Videomass'
VERSION = '5.0.21'
RELSTATE = 'released'
COPYRIGHT = '2013-2024'
WEBSITE = 'http://jeanslack.github.io/Videomass/'
AUTHOR = ('Gianluca Pernigotto', '(aka jeanslack)')
MAIL = 'jeanlucperni@gmail.com'
COMMENT = ("\nThanks to:\n"
           "- Python <https://www.python.org/>, programming language\n"
           "- wxPython <https://wxpython.org/>, cross-platform\n"
           "GUI toolkit for the Python language\n"
           "- FFmpeg, FFmpeg is a trademark of Fabrice Bellard, \n"
           "originator of the FFmpeg project:\n"
           "<http://ffmpeg.org/>\n"
           "- yt-dlp: <https://github.com/yt-dlp/yt-dlp>\n"
           "Download videos from YouTube and more sites\n"
           )
SHORTDESCRIPT = "Videomass is a cross-platform GUI for FFmpeg and yt-dlp"
LONGDESCRIPT = """
Videomass is a powerful, multitasking and cross-platform graphical user
interface (GUI) for FFmpeg and yt-dlp. It offers a wide range of features and
functions, making it a comprehensive software solution.

Videomass is written in Python3 using the wxPython4-Phoenix toolkit.
"""
SHORTLICENSE = "GPL3 (Gnu Public License)"
LICENSE = (f"Copyleft - all rights reversed - {COPYRIGHT} "
           f"{AUTHOR[0]}\n"
           f"Author and developer: {AUTHOR[0]} {AUTHOR[1]}\n"
           f"Mail: {MAIL}\n\n"
           "Videomass is free software: you can redistribute\n"
           "it and/or modify it under the terms of the GNU General\n"
           "Public License as published by the Free Software\n"
           "Foundation, either version 3 of the License, or (at your\n"
           "option) any later version.\n\n"

           "Videomass is distributed in the hope that it\n"
           "will be useful, but WITHOUT ANY WARRANTY; without\n"
           "even the implied warranty of MERCHANTABILITY or\n"
           "FITNESS FOR A PARTICULAR PURPOSE.\n"
           "See the GNU General Public License for more details.\n\n"

           "You should have received a copy of the GNU General\n"
           "Public License along with this program. If not, see\n"
           "http://www.gnu.org/licenses/"
           )
