# Zed Docs

Welcome to Zed's documentation.

This is built on push to `main` and published automatically to [https://zed.dev/docs](https://zed.dev/docs).

To preview the docs locally you will need to install [mdBook](https://rust-lang.github.io/mdBook/) (`cargo install mdbook`) and then run:

```sh
mdbook serve docs
```

## Preprocessor

We have a custom mdbook preprocessor for interfacing with our crates (`crates/docs_preprocessor`).

If for some reason you need to bypass the docs preprocessor, you can comment out `[preprocessor.zed_docs_preprocessor]
` from the `book.toml`.:

## Images and videos

To add images or videos to the docs, upload them to another location (e.g., zed.dev, GitHub's asset storage) and then link out to them from the docs.

Putting binary assets such as images in the Git repository will bloat the repository size over time.

## Internal notes:

- We have a Cloudflare router called `docs-proxy` that intercepts requests to `zed.dev/docs` and forwards them to the "docs" Cloudflare Pages project.
- CI uploads a new version to the Pages project from `.github/workflows/deploy_docs.yml` on every push to `main`.

### Table of Contents

The table of contents files (`theme/page-toc.js` and `theme/page-doc.css`) were initially generated by [`mdbook-pagetoc`](https://crates.io/crates/mdbook-pagetoc).

Since all this preprocessor does does is generate the static assets, we don't need to keep it around once they have been generated.

## Referencing Keybindings and Actions

When referencing keybindings or actions, use the following formats:

### Keybindings:

`{#kb scope::Action}` - e.g., `{#kb zed::OpenSettings}`.

This will output a code element like: `<code>Cmd+,|Ctrl+,</code>`. We then use a client-side plugin to show the actual keybinding based on the user's platform.

By using the action name, we can ensure that the keybinding is always up-to-date rather than hardcoding the keybinding.

### Actions:

`{#action scope::Action}` - e.g., `{#action zed::OpenSettings}`.

This will render a human-readable version of the action name, e.g., "zed: open settings", and will allow us to implement things like additional context on hover, etc.

### Creating New Templates

New templates can be created by implementing the `Template` trait for your desired template in the `docs_preprocessor` crate.

### References

- Template Trait: crates/docs_preprocessor/src/templates.rs
- Example template: crates/docs_preprocessor/src/templates/keybinding.rs
- Client-side plugins: docs/theme/plugins.js
