---
title: Privacy Policy
slug: privacy-policy
---

At Zed Industries, Inc. ("Zed", "Company" or "we"), we take privacy and the security of data seriously. This Privacy Policy is established to help advise you about how we treat your personal data. By using or accessing our website located at zed.dev, or the Solution or services available pursuant the Zed Terms of Use located at [https://zed.dev/terms](https://zed.dev/terms) (collectively, the "Services"), you acknowledge awareness of the practices and policies outlined below, and hereby consent that we will collect, use, and share your personal data as described in this Privacy Policy.

As we grow and expand our Services, we may modify this Privacy Policy from time to time. When material modifications are made, we will alert you to any such changes by placing a notice on the Company website, by sending you an email and/or by some other means. Please note that if you've opted not to receive legal notice emails from us (or haven't provided us with a valid email address), those legal notices will still govern your use of the Services. If you use the Services after any changes to the Privacy Policy have been published on our website, you consent and agree to all of the changes.

## What this Privacy Policy Covers

Our Privacy Policy covers how we treat Personal Data that we gather when you access or use our Services. "Personal Data" means information that identifies or relates to a particular individual and includes information referred to as "personally identifiable information" or "personal information" under applicable data privacy laws, rules or regulations. Our Privacy Policy does not cover the practices of companies we don't own or control or people we don't manage.

## Personal Data

### Categories of Personal Data We Collect

This chart details the categories of Personal Data that we collect and have collected over the past 12 months:

| Category of personal data     | Examples of data we collect                                   | Categories of third parties with whom we share this data |
| ----------------------------- | ------------------------------------------------------------- | -------------------------------------------------------- |
| Profile or contact data       | First and last name<br/>Email address<br/>GitHub username     | Cloud infrastructure providers <br/>Analytics providers  |
| IP data                       | IP address & derived geolocation data                         | Cloud infrastructure providers <br/>Analytics providers  |
| Web analytics                 | Interactions<br/>Referrer<br/>Request IDs<br/>Statistics      | Cloud infrastructure providers <br/>Analytics providers  |
| Photos, videos and recordings | Screenshots<br/>Videos and video recordings you share with us | Cloud infrastructure providers                           |
| Audio, screenshare data       | Audio and screen sharing during collaboration calls           | Cloud infrastructure providers                           |

Note that "collection" does not necessarily imply long-term storage.

### Categories of Sources of Personal Data

We collect Personal Data about you from the following categories of sources:

#### You

- When you provide such information directly to us. Examples include:
  - When you create an account
  - When you voluntarily provide information through our Services or through responses to surveys or questionnaires.
  - When you send us an email or otherwise contact us.
  - When you sign up to our mailing list.
- When you use our hosted Services and such information is collected automatically. Examples include:
  - Cookies (defined in the "Tracking Tools and Opt-Out" section below).
- When you use the client software we provide on your machine. Examples include:
  - Authentication information when you sign in.
  - Version and system metadata when the software checks for updates.
  - Usage data, unless you opt out.
  - Crash reports, unless you opt out.
  - When you make requests to language models we host for you.
    - Zed does not store or train on your requests without consent.
  - Other relevant data necessary to provide you with our Services.

#### Third Parties

- When you login to the service using a third-party service like GitHub.
- Information collected by content delivery networks or similar service providers
- We may use analytics providers to analyze how you interact and engage with the Services, or third parties may help us provide you with customer support.

## Our Business Purposes for Collecting or Disclosing Personal Data

- Providing, Customizing and Improving the Services
  - Creating and managing your account or other user profiles.
  - Processing orders or other fee-based transactions; billing.
  - Providing you with the products, services or information you request.
  - Meeting or fulfilling the reason you provided the information to us.
  - Providing support and assistance for the Services.
  - Improving the Services, including testing, research, internal analytics and product development.
  - Doing fraud protection, security and debugging.
  - Carrying out other business purposes stated when collecting your Personal Data or as otherwise set forth in applicable data privacy laws.
- Marketing the Services
  - Marketing and selling the Services.
- Corresponding with You
  - Responding to correspondence that we receive from you, contacting you when necessary or requested, and sending you information about Zed or our Services.
  - Sending emails and other communications according to your preferences or that display content that we think will interest you.
- Meeting Legal Requirements and Enforcing Legal Terms
  - Fulfilling our legal obligations under applicable law, regulation, court order or other legal process, such as preventing, detecting and investigating security incidents and potentially illegal or prohibited activities.
  - Protecting the rights, property or safety of you, Zed or another party.
  - Enforcing any agreements with you.
  - Responding to claims that any posting or other content violates third-party rights.
  - Resolving disputes.

We will not collect additional categories of Personal Data or use the Personal Data we collected for materially different, unrelated or incompatible purposes without providing you notice as is described above.

## How We Disclose Your Personal Data

We disclose your Personal Data to categories of service providers and other parties listed in this section. Some of these disclosures may constitute a "sale" of your Personal Data as defined under applicable laws. For more information, please refer to the state-specific sections below.

- Service Providers. These parties help us provide the Services or perform business functions on our behalf. They include:
  - Hosting, technology and communication providers.
  - Providers of artificial intelligence or machine learning models
  - Payment processors.
    - If you are using our Services on a fee-basis, our payment processing partner Stripe, Inc. ("Stripe") collects your voluntarily-provided payment card information necessary to process your payment.
    - Please see Stripe Terms of Service and Stripe Privacy Policy for information on its use and storage of your Personal Data.
- Analytics Partners. These parties provide analytics on web traffic or usage of the Services. They include:
  - Companies that track how users found or were referred to the Services.
  - Companies that track how users interact with the Services.
- Authorized authentication providers (e.g. GitHub OAuth)

### Fulfilling Legal Obligations

We may share any Personal Data that we collect with third parties in relation to the activities set forth under "Meeting Legal Requirements and Enforcing Legal Terms" in the "Our Business Purposes for Collecting Personal Data" section above.

### Business Transfers

Personal Data collected may be transferred to a third party if we undergo a merger, acquisition, bankruptcy or other transaction in which such third party assumes control of our business (in whole or in part). In such an event, we will make reasonable efforts to notify you before your information becomes subject to different privacy and security policies and practices as authorized or mandated by applicable law.

## Data that is Not Personal Data

We may create aggregated, de-identified or anonymized data from the Personal Data we collect, including by removing information that makes the data personally identifiable to a particular user. We may use such aggregated, de-identified or anonymized data and share it with third parties for our lawful business purposes, including to analyze, build and improve the Services and promote our business, provided that we will not share such data in a manner that could identify you.

## Tracking Tools and Opt-Out

The Services use cookies and similar technologies such as pixel tags, web beacons, clear GIFs and JavaScript (collectively, "Cookies") to enable our servers to recognize your web browser, tell us how and when you visit and use our Services, analyze trends, learn about our user base and operate and improve our Services. Cookies are small pieces of data– usually text files – placed on your computer, tablet, phone or similar device when you use that device to access our Services. We may also supplement the information we collect from you with information received from third parties, including third parties that have placed their own Cookies on your device(s).

### We use the following types of Cookies:

- Essential Cookies. Essential Cookies are required for providing you with features or services that you have requested. For example, certain Cookies enable you to log into secure areas of our Services. Disabling these Cookies may make certain features and services unavailable.
- Functional Cookies. Functional Cookies are used to record your choices and settings regarding our Services, maintain your preferences over time and recognize you when you return to our Services. These Cookies help us to personalize our content for you, greet you by name and remember your preferences (for example, your choice of language or region).
- Performance/Analytical Cookies. Performance/Analytical Cookies allow us to understand how visitors use our Services. They do this by collecting information about the number of visitors to the Services, what pages visitors view on our Services and how long visitors are viewing pages on the Services. Performance/Analytical Cookies also help us measure the performance of our advertising campaigns to help us improve our campaigns and Services' content for those who engage with our advertising.

You can decide whether or not to accept Cookies through your internet browser's settings. Most browsers have an option for turning off the Cookie feature, which will prevent your browser from accepting new Cookies, as well as (depending on the sophistication of your browser software) allow you to decide on acceptance of each new Cookie in a variety of ways. You can also delete all Cookies that are already on your device. If you do this, however, you may have to manually adjust some preferences every time you visit our website and some of the Services and functionalities may not work.

To find out more information about Cookies generally, including information about how to manage and delete Cookies, please visit [https://allaboutcookies.org/](https://allaboutcookies.org/) or [https://ico.org.uk/for-the-public/online/cookies/](https://ico.org.uk/for-the-public/online/cookies/) if you are located in the European Union.

## Data Security

We endeavor to protect your Personal Data from unauthorized access, use and disclosure using appropriate physical, technical, organizational and administrative security measures based on our Services,the type of Personal Data being collected and how we are processing that data. You should also help protect your data by selecting and protecting your password and/or other sign-on mechanism(s) with care; limiting access to your computer or device and browser; and signing off after you have finished accessing your account. Although we work to protect the security of your account and other data that we hold in our records, be aware that no method of transmitting data over the internet or storing data is completely secure.

## Data Retention

We retain Personal Data about you for as long as reasonably necessary to provide you with our Services or otherwise in support of our business or commercial purposes for utilization of your Personal Data, as expressed. When establishing a retention period for particular categories of data, we consider who we collected the data from, our need for the Personal Data, why we collected the Personal Data, and the sensitivity of the Personal Data. In some cases we retain Personal Data for a longer period, if doing so is necessary to comply with our legal obligations, resolve disputes or collect fees owed, or as is otherwise permitted or required by applicable law, rule or regulation. We may further retain information in an anonymous or aggregated form where such information would not identify you personally.

For example:

- We retain your profile information and credentials for as long as you have an account with us.
- We retain your payment data for as long as we need to process your purchase or subscription.
- We retain your device/IP data for as long as we need it to ensure that our systems are working appropriately, effectively and efficiently.

It's worth noting that we avoid retaining data unless necessary to provide our Service. For example:

- We do not currently store source code that we proxy during collaboration sessions.
- We do not currently store audio or video recordings of Collaboration calls handled by LiveKit.

## Personal Data of Children

We do not knowingly collect or solicit Personal Data from children under 13 years of age; if you are a child under the age of 13, please do not attempt to register for or otherwise use the Services or send us any Personal Data. If we learn we have collected Personal Data from a child under 13 years of age, we will delete that information as quickly as possible. If you believe that a child under 13 years of age may have provided Personal Data to us, please contact us at hi@zed.dev.

## California Resident Rights

If you are a California resident, you have the rights set forth in this section. Please see the "Exercising Your Rights" section below for instructions regarding how to exercise these rights. Please note that we may process Personal Data of our customers' end users or employees in connection with our provision of certain services to our customers. If we are processing your Personal Data as a service provider, you may contact the entity that collected your Personal Data in the first instance to address your rights with respect to such data as desired.

If there are any conflicts between this section and any other provision of this Privacy Policy and you are a California resident, the portion that is more protective of Personal Data shall control to the extent of such conflict. If you have any questions about this section or whether any of the following rights apply to you, please contact us at hi@zed.dev.

### Access

You have the right to request certain information about our collection and use of your Personal Data over the past 12 months. In response, we will provide you with the following information:

- The categories of Personal Data that we have collected about you.
- The categories of sources from which that Personal Data was collected.
- The business or commercial purpose for collecting or selling your Personal Data.
- The categories of third parties with whom we have shared your Personal Data.
- The specific pieces of Personal Data that we have collected about you.
- If we have disclosed your Personal Data to any third parties for a business purpose over the past 12 months, we will identify the categories of Personal Data shared with each category of third party recipient. If we have sold your Personal Data over the past 12 months, we will identify the categories of Personal Data sold to each category of third party recipient.

### Deletion

You have the right to request that we delete the Personal Data that we have collected about you. Under the CCPA, this right is subject to certain exceptions: for e.g., we may need to retain your Personal Data to provide you with the Services or complete a transaction or other action you may have requested, or if deletion of your Personal Data involves disproportionate effort to achieve. If your deletion request is subject to one of these exceptions, we may deny your deletion request to such data.

### Correction

You have the right to request that we correct any inaccurate Personal Data we have collected about you. Under the CCPA, this right is subject to certain exceptions: for example, if we reasonably decide, based on the totality of circumstances related to your Personal Data, that such data is correct. If your correction request is subject to one of these CCPA exceptions, we may deny your request to correct such data.

### Processing of Sensitive Personal Information Opt-Out

Consumers have certain rights over the processing of their sensitive information. However, we do not intentionally collect sensitive categories of personal information, but it is possible to share sensitive information with us through your use of the Services. It is your responsibility not to share any such sensitive information when you use the Services.

### Personal Data Sales Opt-Out and Opt-In

We will not sell your Personal Data, and have not done so over the last 12 months. To our knowledge, we do not sell the Personal Data of minors under 16 years of age. Under the CCPA, California residents have certain rights when a business "shares" Personal Data with third parties for purposes of cross-contextual behavioral advertising. We have shared the foregoing categories of Personal Data for the purposes of cross-contextual behavioral advertising, as applicable.

Under California Civil Code Sections 1798.83-1798.84, California residents are entitled to contact us to prevent disclosure of Personal Data to third parties for such third parties' direct marketing purposes; in order to submit such a request, please contact us at hi@zed.dev.

Your browser may offer you a "Do Not Track" option, which allows you to signal to operators of websites and web applications and services that you do not wish such operators to track certain of your online activities over time and across different websites. Our Services do not support Do Not Track requests at this time. To find out more about "Do Not Track," you can visit [www.allaboutdnt.com](https://www.allaboutdnt.com).

### Exercising Your Rights under CCPA

To exercise the rights described in this Privacy Policy, you or, if you are a California resident, your Authorized Agent (as defined below) can send us a request that (1) provides sufficient information to allow us to adequately verify that you are the person about whom we have collected Personal Data, and (2) describes your request in sufficient detail to allow us to understand, evaluate and respond ( a "Valid Request"). We are not obligated to respond to requests that do not meet these criteria. We will only use Personal Data provided in a Valid Request to verify your identity and complete your request.

We are committed to respond to Valid Requests within the time frame required by applicable law. We will not charge you a fee for making a Valid Request unless your Valid Request(s) is excessive, repetitive or manifestly unfounded. If we determine that your Valid Request warrants a fee, we will notify you of the fee and explain that decision before completing your request.

You may submit a Valid Request using the following methods:

- Email us at: hi@zed.dev

If you are a California resident, you may also authorize an agent (an "Authorized Agent") to exercise your rights on your behalf.

### We Will Not Discriminate Against You for Exercising Your Rights

We will not discriminate against you for exercising your rights under applicable data protection laws. We will not deny you our goods or services, charge you different prices or rates, or provide you a lower quality of goods and services if you exercise your rights under applicable law. However, we may offer different tiers of our Services, as allowed by applicable law, with varying prices, rates or levels of quality of the goods or services you receive related to the value of Personal Data that we receive from you.

# European Union and United Kingdom Data Subject Rights

## EU and UK Residents

If you are a resident of the European Union ("EU"), United Kingdom ("UK"), Lichtenstein, Norway or Iceland, you may have additional rights under the EU or UK General Data Protection Regulation (the "GDPR") with respect to your Personal Data, as outlined below.
We use the terms "Personal Data" and "processing" as they are defined in the GDPR in this section, but "Personal Data" generally means information that can be used to individually identify a person, and "processing" generally covers actions that can be performed in connection with data such as collection, use, storage and disclosure. Company will be the controller of your Personal Data processed in connection with the Services.
If there are any conflicts between this section and any other provision of this Privacy Policy, the policy or portion that is more protective of Personal Data shall control to the extent of such conflict. If you have any questions about this section or whether any of the following applies to you, please contact us at hi@zed.dev. Note that we may also process Personal Data of our customers' end users or employees in connection with our provision of certain services to you, in which case we are the processor of Personal Data. If we are the processor of your Personal Data, please contact the controller party in the first instance to address your rights with respect to such data.

## Personal Data We Collect

The "Categories of Personal Data We Collect" section above details the Personal Data that we collect from you.

## Personal Data Use and Processing Grounds

The "Our Commercial or Business Purposes for Collecting Personal Data" section above explains how we use your Personal Data.

We will only process your Personal Data if we have a lawful basis for doing so. Lawful bases for processing include consent, contractual necessity and our "legitimate interests" or the legitimate interest of others, as further described below.

- Contractual Necessity: We process the following categories of Personal Data as a matter of "contractual necessity", meaning that we need to process the data to perform under our Terms of Use with you, which enables us to provide you with the Services. When we process data due to contractual necessity, failure to provide such Personal Data will result in your inability to use some or all portions of the Services that require such data.
  - Profile or Contact Data
  - Payment Data
- Legitimate Interest: We process the following categories of Personal Data when we believe it furthers the legitimate interest of us or third parties:
  - Device/IP Data
  - Web Analytics
  - We may also de-identify or anonymize Personal Data to further our legitimate interests.
- Examples of these legitimate interests include (as described in more detail above):
  - Providing, customizing and improving the Services.
  - Marketing the Services.
  - Corresponding with you.
  - Meeting legal requirements and enforcing legal terms.
  - Completing corporate transactions.
- Consent: In some cases, we process Personal Data based on the consent you expressly grant to us at the time we collect such data.
  - Other Processing Grounds: From time to time we may also need to process Personal Data to comply with a legal obligation, if it is necessary to protect the interests of you or other data subjects, or if it is necessary in the public interest.

## Sharing Personal Data

The "How We Share Your Personal Data" section above details how we share your Personal Data with third parties.

## EU Data Subject Rights

For more information about these EU or UK personal data terms and your rights related thereto, or to submit a request for information, please email us at hi@zed.dev. Please note that in some circumstances, we may not be able to fully comply with your request, such as if it is frivolous or impractical, if it jeopardizes the rights of others, or if it is not required by law, but, in those circumstances, we are committed to respond to notify you of such a decision regardless. In some cases, we may also need you to provide us with additional information, which may include Personal Data, if necessary to verify your identity and the nature of your request.

- Access: You can request more information about the Personal Data we hold about you and request a copy of such Personal Data. You can also access certain of your Personal Data by logging on to your account.
- Rectification: If you believe that any Personal Data we are holding about you is incorrect or incomplete, you can request that we correct or supplement such data. You can also correct some of this information directly by logging on to your account.
- Erasure: You can request that we erase some or all of your Personal Data from our systems.
- Withdrawal of Consent: If we are processing your Personal Data based on your consent, you have the right to withdraw your consent at any time. Please note, however, that if you exercise this right, you may have to then provide express consent on a case-by-case basis for the use or disclosure of certain of your Personal Data, if such use or disclosure is necessary to enable you to utilize some or all of our Services.
- Portability: You can ask for a copy of your Personal Data in a machine-readable format. You can also request that we transmit the data to another controller where technically feasible.
- Objection: You can contact us to let us know that you object to the further use or disclosure of your Personal Data for certain purposes, such as for direct marketing purposes.
- Restriction of Processing: You can ask us to restrict further processing of your Personal Data.
- Right to File Complaint: You have the right to lodge a complaint about Company's practices with respect to your Personal Data with the supervisory authority of your country or EU Member State. A list of Supervisory Authorities is available here: [https://edpb.europa.eu/about-edpb/board/members_en](https://edpb.europa.eu/about-edpb/board/members_en)

## Transfers of Personal Data

The Services are hosted and operated in the United States ("U.S.") through Company and its service providers. By using the Services, you acknowledge that any Personal Data about you is being provided to Company in the U.S. and will be hosted on U.S. servers, and you authorize Company to transfer, store and process your information to and in the U.S., and possibly other countries. In some circumstances, your Personal Data may be transferred to the U.S. pursuant to a data processing agreement incorporating legally required data protection clauses.

# Contact Information:

If you have additional questions about this Privacy Policy, the methods in which we collect and use your Personal Data or your choices and rights regarding such collection and use, please do not hesitate to contact us at:

- Website: zed.dev
- Email Address: hi@zed.dev
- Corporate Address:
  Zed Industries, Inc.
  2590 Welton St
  Suite 200
  PO Box 1916
  Denver CO 80205

**DATE: September 1, 2024**
