/**
 * @ignore
 * BEGIN HEADER
 *
 * Contains:        RootClose command
 * CVM-Role:        <none>
 * Maintainer:      Hendrik Erz
 * License:         GNU GPL v3
 *
 * Description:     This command closes a root file or directory.
 *
 * END HEADER
 */

import ZettlrCommand from './zettlr-command'

export default class RootClose extends ZettlrCommand {
  constructor (app: any) {
    super(app, 'root-close')
  }

  /**
   * Closes (not removes) either a directory or a file.
   * @param {String} evt The event name
   * @param  {Object} arg The hash of a root directory or file.
   */
  async run (evt: string, arg: any): Promise<boolean> {
    // We got a root, so now we need to unload it and remove it from config
    this._app.config.removePath(arg)
    return true
  }
}
