---
title: "Welkom bij Zettlr!"
keywords:
  - Handleiding
  - Tutorial
  - Inleiding
...

# Welkom bij Zettlr!

 ![zettlr.png](./zettlr.png)

Hallo en bedankt om voor Zettlr te kiezen! 🎉 We hebben deze interactieve instructies voor Zettlr gemaakt zodat je de toepassing meteen kan leren kennen zonder de hele gebruikershandleiding te moeten doornemen. Weet dat met Zettlr nog veel meer mogelijk is dan wat deze korte inleiding kan schetsen, dus twijfel niet om ook [🔗 de uitgebreide handleiding](https://docs.zettlr.com/) te raadplegen (houd `Cmd` of `Ctrl` ingedrukt terwijl je op de link klikt om deze te openen). De handleiding is er in verschillende talen en helpt je met de vele functies van Zettlr om te gaan. Je kan de online handleiding steeds openen door `F1` te drukken of op "Open gebruikershandleiding" te klikken in het "Help"-menu.

Hier gaan we!

> In deze tutorial vind je weblinks die je kan volgen. Klikken op de link laat je toe de link te bewerken. Om de link te openen hou je de `Cmd`-toets (als je macOS gebruikt) of de `Ctrl`-toets (op Windows of Linux) ingedrukt terwijl je op de link klikt! Wanneer in de tutorial of handleiding `Cmd/Ctrl` staat kan je dat in gedachten steeds vervangen door “Gebruik `Cmd` als je macOS gebruikt en anders `Ctrl`.”

## Over deze tutorial 🎬

Er zijn wel meer Markdownapplicaties die een gelijkaardige interactieve tutorial gebruiken om je actief te laten kennismaken met de toepassing. Hier bij Zettlr hebben we een kleine map in je documentenmap aangemaakt met de naam "Zettlr Tutorial" en deze voor je geopend. Op dit moment zie je de inhoud van die map in de linkerzijbalk, de "bestandsmanager". Laat ons eens een kijkje nemen! Als je je muisaanwijzer naar de bovenkant van de bestandsmanager brengt, verschijnt er een pijl in een cirkel. Klik op het pijltje.

Je zal zien dat er één map, namelijk de tutorial, geladen is. Een map op dit hoogste niveau wordt werkruimte genoemd. Je kan met de rechtermuisknop op een map klikken en ze "sluiten" of "verwijderen". Als je een werkruimte _sluit_ in Zettlr, betekent dat dat de toepassing de map niet meer laadt, maar de map blijft wel op je computer. Als je een map _verwijdert_ zal Zettlr de map naar de prullenbak verplaatsen. Doe dat nu nog niet, want er valt nog veel nieuws te leren! ✍🏼

> NB In sommige Linuxdistributies werkt dit niet meteen omdat Zettlr een bepaald pakket nodig heeft om bestanden naar de prullenbak te verplaatsen. Als je problemen hebt met het verwijderen van bestanden en mappen, vind je hulp bij onze [veelgestelde vragen](https://docs.zettlr.com/en/faq/#im-using-linux-and-deleting-files-doesnt-move-them-to-the-trash)!

Bij het maken van Zettlr stond het concept van werkruimtes centraal. Je zal dus de beste ervaring hebben als je altijd minstens één werkruimte open hebt en al je werk daarin doet. De werkruimtes worden telkens wanneer je Zettlr opent automatisch geladen en worden getoond in de boomstructuur van mappen die je nu kan zien. Klik op een map om de lijst met bestanden in die map te zien.

> Er zijn drie manieren om de bestandsmanager weer te geven waaruit je in de voorkeuren kan kiezen. Eén geeft ofwel de lijst met bestanden, ofwel de boomstructuur van mappen weer (de huidige modus), een tweede geeft beide naast elkaar weer (de uitgeklapte modus) en de derde geeft zowel bestanden als mappen door elkaar weer zoals in een gebruikelijke bestandsverkenner. Je kan dit later veranderen in de instellingen.

Klik nu op "Zettlr Tutorial" om terug te keren naar de bestandslijst.

## Markdown gebruiken 📝

Zettlr is een teksteditor en werkt dus grotendeels zoals toepassingen die je al kent, bijvoorbeeld Microsoft Word, LibreOffice of Apple Pages. Maar in plaats van je door een resem knoppen in de toolbar te klikken kan je tekstelementen structureren met tekens, zodat je je toetsenbord nooit hoeft te verlaten! ✨

Dit zijn de belangrijkste elementen in een notendop:

1. Je kan tekst **vet** en _cursief_ maken door ze met underscores of asterisken te omringen. Je kan zelf kiezen welke van beide je gebruikt. Eén teken maakt tekst cursief, twee tekens maken tekst vet en drie tekens maken tekst ***vet en cursief***.
2. Koppen worden bijna op dezelfde manier als hashtags gemaakt: schrijf een `#`-teken gevolgd door een spatie. Je kan tot zes `######`-tekens gebruiken om koppen van niveau één tot zes te maken.
3. Lijstjes kan je heel eenvoudig maken door `*`, `-`, of `+` op een nieuwe lijn te typen. Genummerde lijsten bestaan uit een cijfer gevolgd door een punt.
4. Blokcitaten worden geschreven zoals aangehaalde tekst ook in e-mails wordt weergegeven: baken ze af met `>`.

Er zijn natuurlijk veel andere elementen. Voetnoten, bijvoorbeeld – beweeg je muisaanwijzer over deze.[^1] In deze tutorial zal je leren over bijzondere elementen van Zettlr die je in staat stellen echt academisch werk te verrichten, én kennisbeheer met gebruik van Zettelkasten!

## Links ⛓

Hoewel links niet dikwijls worden gebruikt in wetenschappelijke teksten zijn ze een krachtig instrument van Markdown. Zettlr doet daar nog een schepje bovenop en behandelt links op een slimme manier. Laten we er snel één maken! Kopieer de volgende link naar het klembord: https://fosstodon.org/@zettlr

Selecteer nu de volgende woorden: "link naar ons Mastodonaccount" en druk `Cmd/Ctrl+K`! Zettlr ziet dat je een geldige weblink in je clipboard hebt en gebruikt dit automatisch als het doel van de koppeling. Zettlr zal het koppelingsdoel ook automatisch verbergen en alleen de verlinkte tekst weergeven, zodat je tekst makkelijker leesbaar is. Als je niet houdt van sommige elementen die Zettlr standaard rendert, kan je dat aanpassen in de "Display" voorkeuren.

Zettlr ondersteunt niet alleen gewone weblinks. Als je een bestand op je computer verlinkt kan Zettlr het openen wanneer je op zo'n koppeling klikt. Zettlr probeert je schrijfervaring zo soepel als mogelijk te maken, niet alleen op vlak van links.

## De zijbalk 📎

Nu je de beginselen van Markdown kent is het tijd om je te laten zien wat Zettlr nog meer kan! Klik op het kolom-achtige icoontje in de rechterbovenhoek van de toolbar. Zo open je de zijbalk, die vier tabbladen bevat.

Het eerste tabblad toont een dynamisch gegenereerde inhoudsopgave. Je kan op de koppen klikken om naar die sectie te springen in de tekst.

Het tweede tabblad toont verwijzingen – als je er hebt in je huidige document. Het is een hulprijk middel om na te kijken wat je hebt geciteerd in een document.

> Deze verwijzingen worden weergegeven in de ingebouwde citatiestijl. Als je je document exporteert, zal Zettlr de citatiestijl die je zelf hebt gekozen gebruiken, als je zo'n stijl hebt ingesteld in de "Export"-voorkeuren (daarover later meer).

Het derde tabblad bevat gerelateerde bestanden, met andere woorden bestanden waarvan Zettlr denkt dat ze aan je huidige bestand gerelateerd zijn. Daarvoor kijkt Zettlr naar tags en interne links (waarover later meer) die je in al je bestanden gebruikt. Bovenaan de lijst staan bestanden die een koppeling naar je huidige bestand bevatten. Daarna volgen bestanden die tags gemeenschappelijk hebben met je huidige bestand, waarbij degene die de meeste tags gemeenschappelijk hebben hoger in de lijst staan.

Het laatste tabblad toont alle bestanden in je huidige map die geen Markdownbestanden zijn. Je zal er een bestand zien dat "LaTeX Guide.pdf" heet. Benieuwd naar wat het is? Klik erop om het in je standaard PDF-programma te bekijken!

## Interactieve elementen ⏯

Je hebt al veel over Zettlr geleerd. Kan je alle vakjes afvinken?

- [ ] Werken met bestanden en mappen
- [ ] Grondbeginselen van Markdown geleerd
- [ ] LaTeX geïnstalleerd om mijn bestanden te exporteren

Sommige elementen in de editor zijn interactief, net als de aankruisvakjes. Een ander voorbeeld zijn tabellen. Bekijk de onderstaande tabel: beweeg je muisaanwijzer erover en kijk welke knoppen verschijnen die je laten werken met de tabel!

| Bestand                 | Doel                                                                   | Bestandsnaam    |
|-------------------------|------------------------------------------------------------------------|-----------------|
| Welkom bij Zettlr!      | Geeft een kort overzicht van wat Zettlr kan                            | welcome.md      |
| Werken met Zettelkästen | Laat je kennismaken met de veelzijdige Zettelkastenfuncties van Zettlr | zettelkasten.md |
| Citeren met Zettlr      | Belicht de mogelijkheden van werken met referentiedatabases            | citing.md       |

Je kan kolommen uitlijnen en rijen of kolommen toevoegen of verwijderen. De tabeleditor werkt altijd met de rij of kolom die op dit moment actief is. Om een bepaalde rij te verwijderen moet je dus eerst een tabelcel in die rij selecteren. Neem je tijd om met de tabel te spelen en aan de werking te wennen!

## Meer info 📚

Je bent er geraakt! Het eerste deel van de introductie is voorbij. Veel bestreek deze inleiding nog niet, maar je kan alles leren in onze [gebruikershandleiding](https://docs.zettlr.com/)! Misschien ben je wel geïnteresseerd in onze [krachtige tag manager](https://docs.zettlr.com/en/reference/settings/#manage-tags), of de [veelzijdige zoekopties](https://docs.zettlr.com/en/core/search/).

Genoeg basics nu! Laten we naar de Zettelkasten-tutorial gaan. Druk `Cmd/Ctrl` en klik op de volgende koppeling: [[zettelkasten]]

[^1]: Deze tekst staat onderaan dit bestand, maar in principe kan je voetnoten plaatsen waar je maar wilt. Zettlr zal de bijhorende voetnoottekst weergeven wanneer je je muisaanwijzer over een voetnoot beweegt, zodat je niet hoeft te scrollen om te lezen wat erin staat.

